<?php
// admin-dashboard.php
session_start();
require_once __DIR__ . '/config.php';

if (empty($_SESSION['lead_hub_admin'])) {
    header('Location: admin-login.php');
    exit;
}

$pdo = get_pdo();

// فلاتر
$country_filter = trim($_GET['country'] ?? '');
$type_filter    = trim($_GET['project_type'] ?? '');
$brand_filter   = trim($_GET['brand'] ?? '');
$from_date      = trim($_GET['from'] ?? '');
$to_date        = trim($_GET['to'] ?? '');

$where = [];
$params = [];

if ($country_filter !== '') {
    $where[] = 'country_code = :country_code';
    $params[':country_code'] = $country_filter;
}
if ($type_filter !== '') {
    $where[] = 'project_type = :project_type';
    $params[':project_type'] = $type_filter;
}
if ($brand_filter !== '') {
    $where[] = 'brand = :brand';
    $params[':brand'] = $brand_filter;
}
if ($from_date !== '') {
    $where[] = 'DATE(created_at) >= :from_date';
    $params[':from_date'] = $from_date;
}
if ($to_date !== '') {
    $where[] = 'DATE(created_at) <= :to_date';
    $params[':to_date'] = $to_date;
}

$where_sql = $where ? ('WHERE ' . implode(' AND ', $where)) : '';
$sql = "SELECT * FROM lead_requests {$where_sql} ORDER BY created_at DESC LIMIT 500";
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>لوحة التحكم - Lead Hub</title>
  <style>
    body {
      background: #f3f4f6;
      font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
      direction: rtl;
      text-align: right;
      padding: 20px;
    }
    h1 {
      font-size: 22px;
      margin-bottom: 10px;
    }
    .top-bar {
      display: flex;
      justify-content: space-between;
      align-items: center;
      margin-bottom: 20px;
      gap: 10px;
      flex-wrap: wrap;
    }
    .filters {
      background: #fff;
      padding: 10px 12px;
      border-radius: 12px;
      box-shadow: 0 5px 15px rgba(0,0,0,0.03);
      display: flex;
      gap: 8px;
      flex-wrap: wrap;
      align-items: center;
    }
    .filters input,
    .filters select {
      padding: 6px 8px;
      border-radius: 8px;
      border: 1px solid #ddd;
      font-size: 13px;
    }
    .filters button {
      padding: 7px 14px;
      border-radius: 999px;
      border: none;
      background: #2563eb;
      color: #fff;
      font-size: 13px;
      cursor: pointer;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 15px;
      background: #fff;
      border-radius: 12px;
      overflow: hidden;
      box-shadow: 0 10px 25px rgba(0,0,0,0.05);
    }
    th, td {
      padding: 8px 10px;
      font-size: 13px;
      border-bottom: 1px solid #eee;
      vertical-align: top;
    }
    th {
      background: #f9fafb;
      font-weight: 600;
    }
    tr:last-child td {
      border-bottom: none;
    }
    .badge {
      display: inline-block;
      padding: 2px 8px;
      border-radius: 999px;
      font-size: 11px;
      background: #e5e7eb;
    }
    .badge.success { background: #dcfce7; color: #166534; }
    .badge.error { background: #fee2e2; color: #b91c1c; }
    .badge.pending { background: #fef3c7; color: #92400e; }
    a.logout {
      color: #b91c1c;
      text-decoration: none;
      font-size: 13px;
    }
    .page-url {
      font-size: 11px;
      color: #2563eb;
      word-break: break-all;
    }
    .details {
      white-space: pre-wrap;
      font-size: 12px;
    }
  </style>
</head>
<body>
  <div class="top-bar">
    <h1>لوحة التحكم - طلبات العملاء</h1>
    <div>
      <a href="admin-logout.php" class="logout">تسجيل خروج</a>
    </div>
  </div>

  <form class="filters" method="GET">
    <div>
      <label>الدولة:</label>
      <select name="country">
        <option value="">الكل</option>
        <option value="SA" <?php if($country_filter==='SA') echo 'selected';?>>السعودية</option>
        <option value="EG" <?php if($country_filter==='EG') echo 'selected';?>>مصر</option>
        <option value="JO" <?php if($country_filter==='JO') echo 'selected';?>>الأردن</option>
        <option value="AE" <?php if($country_filter==='AE') echo 'selected';?>>الإمارات</option>
      </select>
    </div>
    <div>
      <label>نوع المشروع:</label>
      <select name="project_type">
        <option value="">الكل</option>
        <option value="بناء"   <?php if($type_filter==='بناء') echo 'selected';?>>بناء</option>
        <option value="ترميم" <?php if($type_filter==='ترميم') echo 'selected';?>>ترميم</option>
        <option value="تشطيب" <?php if($type_filter==='تشطيب') echo 'selected';?>>تشطيب</option>
        <option value="ديكور" <?php if($type_filter==='ديكور') echo 'selected';?>>ديكور</option>
      </select>
    </div>
    <div>
      <label>البراند:</label>
      <select name="brand">
        <option value="">الكل</option>
        <option value="miras"     <?php if($brand_filter==='miras') echo 'selected';?>>Miras</option>
        <option value="emargates" <?php if($brand_filter==='emargates') echo 'selected';?>>Emar Gates</option>
      </select>
    </div>
    <div>
      <label>من تاريخ:</label>
      <input type="date" name="from" value="<?php echo htmlspecialchars($from_date, ENT_QUOTES, 'UTF-8'); ?>">
    </div>
    <div>
      <label>إلى تاريخ:</label>
      <input type="date" name="to" value="<?php echo htmlspecialchars($to_date, ENT_QUOTES, 'UTF-8'); ?>">
    </div>
    <div>
      <button type="submit">تطبيق الفلاتر</button>
    </div>
  </form>

  <table>
    <thead>
      <tr>
        <th>#</th>
        <th>الاسم</th>
        <th>الجوال</th>
        <th>الدولة / المدينة</th>
        <th>نوع المشروع</th>
        <th>حساب تكلفة؟</th>
        <th>البراند</th>
        <th>الحالة</th>
        <th>الصفحة</th>
        <th>التفاصيل</th>
        <th>التاريخ</th>
      </tr>
    </thead>
    <tbody>
      <?php if (!$rows): ?>
        <tr><td colspan="11">لا توجد طلبات مطابقة للفلاتر.</td></tr>
      <?php else: ?>
        <?php foreach ($rows as $row): ?>
          <tr>
            <td><?php echo (int)$row['id']; ?></td>
            <td><?php echo htmlspecialchars($row['client_name'], ENT_QUOTES, 'UTF-8'); ?></td>
            <td>
              <?php echo htmlspecialchars($row['client_phone_normalized'], ENT_QUOTES, 'UTF-8'); ?><br>
              <small><?php echo htmlspecialchars($row['client_phone_raw'], ENT_QUOTES, 'UTF-8'); ?></small>
            </td>
            <td>
              <?php echo htmlspecialchars($row['country_name'], ENT_QUOTES, 'UTF-8'); ?><br>
              <small><?php echo htmlspecialchars($row['city_district'], ENT_QUOTES, 'UTF-8'); ?></small>
            </td>
            <td><?php echo htmlspecialchars($row['project_type'], ENT_QUOTES, 'UTF-8'); ?></td>
            <td><?php echo !empty($row['want_estimated_cost']) ? 'نعم' : 'لا'; ?></td>
            <td><?php echo htmlspecialchars($row['brand'], ENT_QUOTES, 'UTF-8'); ?></td>
            <td>
              <span class="badge <?php echo htmlspecialchars($row['email_status'], ENT_QUOTES, 'UTF-8'); ?>">Email: <?php echo htmlspecialchars($row['email_status'], ENT_QUOTES, 'UTF-8'); ?></span><br>
              <span class="badge <?php echo htmlspecialchars($row['whatsapp_status'], ENT_QUOTES, 'UTF-8'); ?>">WA: <?php echo htmlspecialchars($row['whatsapp_status'], ENT_QUOTES, 'UTF-8'); ?></span><br>
              <span class="badge <?php echo htmlspecialchars($row['make_status'], ENT_QUOTES, 'UTF-8'); ?>">Make: <?php echo htmlspecialchars($row['make_status'], ENT_QUOTES, 'UTF-8'); ?></span>
            </td>
            <td>
              <?php if (!empty($row['page_url'])): ?>
                <a href="<?php echo htmlspecialchars($row['page_url'], ENT_QUOTES, 'UTF-8'); ?>" target="_blank" class="page-url">
                  <?php echo htmlspecialchars($row['page_url'], ENT_QUOTES, 'UTF-8'); ?>
                </a>
              <?php endif; ?>
            </td>
            <td class="details">
              <?php echo nl2br(htmlspecialchars($row['project_details'], ENT_QUOTES, 'UTF-8')); ?>
            </td>
            <td><?php echo htmlspecialchars($row['created_at'], ENT_QUOTES, 'UTF-8'); ?></td>
          </tr>
        <?php endforeach; ?>
      <?php endif; ?>
    </tbody>
  </table>
</body>
</html>
