<?php
// admin-login.php
session_start();
require_once __DIR__ . '/config.php';

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';

    if ($username === ADMIN_USERNAME && password_verify($password, ADMIN_PASSWORD_HASH)) {
        $_SESSION['lead_hub_admin'] = true;
        header('Location: admin-dashboard.php');
        exit;
    } else {
        $error = 'بيانات الدخول غير صحيحة.';
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>تسجيل دخول الأدمن - Lead Hub</title>
  <style>
    body {
      background: #f3f4f6;
      font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
      direction: rtl;
      text-align: right;
    }
    .login-box {
      max-width: 360px;
      margin: 80px auto;
      padding: 24px;
      background: #ffffff;
      border-radius: 12px;
      box-shadow: 0 10px 25px rgba(0,0,0,0.05);
    }
    h1 {
      font-size: 20px;
      margin-bottom: 16px;
    }
    .form-group {
      margin-bottom: 15px;
    }
    label {
      display: block;
      margin-bottom: 5px;
      font-weight: 600;
    }
    input[type="text"],
    input[type="password"] {
      width: 100%;
      padding: 10px 12px;
      border-radius: 8px;
      border: 1px solid #ddd;
      font-size: 14px;
      box-sizing: border-box;
    }
    button {
      width: 100%;
      padding: 10px;
      border-radius: 999px;
      border: none;
      background: #2563eb;
      color: #fff;
      font-weight: 600;
      cursor: pointer;
    }
    .error {
      margin-bottom: 12px;
      padding: 10px;
      border-radius: 8px;
      background: #fee2e2;
      color: #b91c1c;
      font-size: 14px;
    }
  </style>
</head>
<body>
  <div class="login-box">
    <h1>تسجيل دخول الأدمن</h1>
    <?php if ($error): ?>
      <div class="error"><?php echo htmlspecialchars($error, ENT_QUOTES, 'UTF-8'); ?></div>
    <?php endif; ?>
    <form method="POST">
      <div class="form-group">
        <label for="username">اسم المستخدم</label>
        <input type="text" id="username" name="username" required>
      </div>
      <div class="form-group">
        <label for="password">كلمة المرور</label>
        <input type="password" id="password" name="password" required>
      </div>
      <button type="submit">دخول</button>
    </form>
  </div>
</body>
</html>
