CREATE TABLE `lead_requests` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `client_name` VARCHAR(191) NOT NULL,
  `client_phone_raw` VARCHAR(50) NOT NULL,
  `client_phone_normalized` VARCHAR(30) NOT NULL,
  `country_code` VARCHAR(10) NOT NULL,
  `country_name` VARCHAR(100) NOT NULL,
  `country_dial_code` VARCHAR(10) NOT NULL,
  `city_district` VARCHAR(191) NOT NULL,
  `project_type` VARCHAR(50) NOT NULL,
  `project_details` TEXT NOT NULL,
  `want_estimated_cost` TINYINT(1) NOT NULL DEFAULT 0,
  `page_url` TEXT,
  `brand` VARCHAR(50) DEFAULT 'miras',
  `ip_address` VARCHAR(45),
  `user_agent` TEXT,
  `is_human` TINYINT(1) DEFAULT 1,
  `whatsapp_status` VARCHAR(50) DEFAULT 'pending',
  `email_status` VARCHAR(50) DEFAULT 'pending',
  `make_status` VARCHAR(50) DEFAULT 'pending',
  `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `project_type_idx` (`project_type`),
  KEY `country_code_idx` (`country_code`),
  KEY `brand_idx` (`brand`),
  KEY `created_at_idx` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
