<?php
// form-embed.php
// نموذج موحد لمشاريع البناء/التشطيب/الديكور

// تحديد البراند حسب الدومين أو تمريره كـ GET/شورتكود
$brand = 'miras';
if (isset($_GET['brand'])) {
    $brand = preg_replace('/[^a-zA-Z0-9_-]/', '', $_GET['brand']);
}
?>
<style>
.miras-lead-form {
  max-width: 480px;
  margin: 20px auto;
  padding: 20px;
  border-radius: 12px;
  background: #ffffff;
  box-shadow: 0 10px 25px rgba(0,0,0,0.05);
  font-family: inherit;
  direction: rtl;
  text-align: right;
}
.miras-lead-form .form-group {
  margin-bottom: 15px;
}
.miras-lead-form label {
  display: block;
  font-weight: 600;
  margin-bottom: 5px;
}
.miras-lead-form input[type="text"],
.miras-lead-form input[type="tel"],
.miras-lead-form select,
.miras-lead-form textarea {
  width: 100%;
  padding: 10px 12px;
  border-radius: 8px;
  border: 1px solid #ddd;
  font-size: 14px;
  box-sizing: border-box;
}
.miras-lead-form textarea {
  resize: vertical;
}
.miras-lead-form small.help-text {
  font-size: 12px;
  color: #777;
}
.miras-lead-form .phone-row {
  display: flex;
  gap: 8px;
}
.miras-lead-form .phone-row select {
  flex: 0 0 45%;
}
.miras-lead-form .phone-row input {
  flex: 1;
}
.miras-lead-form .form-message {
  margin-top: 10px;
  padding: 10px 12px;
  border-radius: 8px;
  font-size: 14px;
}
.miras-lead-form .form-message.success {
  background: #e6f9f0;
  color: #047857;
}
.miras-lead-form .form-message.error {
  background: #fee2e2;
  color: #b91c1c;
}
.miras-lead-form button[type="submit"] {
  width: 100%;
  padding: 12px;
  border-radius: 999px;
  background: #2563eb;
  color: #fff;
  border: none;
  font-size: 15px;
  font-weight: 600;
  cursor: pointer;
}
.miras-lead-form button[type="submit"]:disabled {
  opacity: 0.7;
  cursor: not-allowed;
}
.miras-lead-form .captcha-row {
  display: flex;
  align-items: center;
  gap: 8px;
}
.miras-lead-form .captcha-row input[type="checkbox"] {
  width: 18px;
  height: 18px;
}
@media (max-width: 600px) {
  .miras-lead-form {
    margin: 10px;
    padding: 16px;
  }
  .miras-lead-form .phone-row {
    flex-direction: column;
  }
}
</style>

<form id="miras-lead-form" class="miras-lead-form">
  <!-- حقول خفية للمصدر والبراند -->
  <input type="hidden" name="page_url" id="page_url" value="">
  <input type="hidden" name="brand" id="brand" value="<?php echo htmlspecialchars($brand, ENT_QUOTES, 'UTF-8'); ?>">
  <input type="hidden" name="country_dial_code" id="country_dial_code" value="">

  <!-- الاسم -->
  <div class="form-group">
    <label for="client_name">الاسم الكامل<span style="color:red">*</span></label>
    <input type="text" id="client_name" name="client_name" required placeholder="اكتب اسمك هنا">
  </div>

  <!-- رقم الجوال + مفتاح الدولة -->
  <div class="form-group">
    <label for="client_phone">رقم الجوال<span style="color:red">*</span></label>
    <div class="phone-row">
      <select id="client_country" name="client_country" required>
        <option value="">اختر الدولة</option>
        <option value="SA" data-dial="966">السعودية (+966)</option>
        <option value="AE" data-dial="971">الإمارات (+971)</option>
        <option value="EG" data-dial="20">مصر (+20)</option>
        <option value="JO" data-dial="962">الأردن (+962)</option>
        <option value="KW" data-dial="965">الكويت (+965)</option>
        <option value="QA" data-dial="974">قطر (+974)</option>
        <option value="BH" data-dial="973">البحرين (+973)</option>
        <option value="OM" data-dial="968">عمان (+968)</option>
        <option value="LB" data-dial="961">لبنان (+961)</option>
        <option value="IQ" data-dial="964">العراق (+964)</option>
        <option value="SY" data-dial="963">سوريا (+963)</option>
        <option value="YE" data-dial="967">اليمن (+967)</option>
        <option value="LY" data-dial="218">ليبيا (+218)</option>
        <option value="TN" data-dial="216">تونس (+216)</option>
        <option value="DZ" data-dial="213">الجزائر (+213)</option>
        <option value="MA" data-dial="212">المغرب (+212)</option>
        <option value="SD" data-dial="249">السودان (+249)</option>
        <option value="PS" data-dial="970">فلسطين (+970)</option>
      </select>
      <input type="tel" id="client_phone" name="client_phone" required placeholder="اكتب رقم الجوال هنا">
    </div>
    <small class="help-text">
      يمكنك كتابة الرقم مع أو بدون صفر في البداية، أو حتى مع المفتاح الدولي. سنقوم نحن بتنسيقه تلقائياً.
    </small>
  </div>

  <!-- المدينة والحي -->
  <div class="form-group">
    <label for="city_district">المدينة والحي<span style="color:red">*</span></label>
    <input type="text" id="city_district" name="city_district" required placeholder="مثال: جدة - حي الحمدانية">
  </div>

  <!-- نوع المشروع -->
  <div class="form-group">
    <label for="project_type">نوع المشروع المطلوب<span style="color:red">*</span></label>
    <select id="project_type" name="project_type" required>
      <option value="">اختر نوع المشروع</option>
      <option value="بناء">بناء</option>
      <option value="ترميم">ترميم</option>
      <option value="تشطيب">تشطيب</option>
      <option value="ديكور">ديكور</option>
    </select>
  </div>

  <!-- تفاصيل المشروع -->
  <div class="form-group">
    <label for="project_details">تفاصيل المشروع<span style="color:red">*</span></label>
    <textarea id="project_details" name="project_details" rows="4" required
      placeholder="مثال: بناء فيلا دورين على أرض مساحتها 400م في حي ..., تشطيب متوسط، الميزانية التقريبية من ... إلى ...، وأي تفاصيل إضافية تساعدنا على خدمتك بشكل أفضل."></textarea>
  </div>

  <!-- هل تريد حساب تكلفة افتراضية؟ -->
  <div class="form-group">
    <label>خيار إضافي (اختياري)</label>
    <div class="captcha-row">
      <input type="checkbox" id="want_estimated_cost" name="want_estimated_cost" value="1">
      <span>هل تريد أن نقوم بحساب تكلفة افتراضية لمشروعك وإرسالها لك؟</span>
    </div>
    <small class="help-text">
      سنستخدم المعلومات التي تكتبها عن المشروع (المساحة، نوع التشطيب، المدينة...) لتقدير تكلفة تقريبية تساعدك في تكوين صورة أوضح قبل البدء.
    </small>
  </div>

  <!-- كابتشا كليك (تأكيد أنه بشري) -->
  <div class="form-group">
    <label>تأكيد بسيط<span style="color:red">*</span></label>
    <div class="captcha-row">
      <input type="checkbox" id="human_check" name="human_check" value="1">
      <span>أؤكد أنني إنسان ولست روبوت 🤖</span>
    </div>
  </div>

  <!-- حقل Honeypot مخفي -->
  <div class="form-group" style="display:none;">
    <label for="extra_field">لا تعبئ هذا الحقل</label>
    <input type="text" id="extra_field" name="extra_field" value="" autocomplete="off">
  </div>

  <!-- رسالة الحالة -->
  <div id="miras-form-message" class="form-message" style="display:none;"></div>

  <!-- زر الإرسال -->
  <button type="submit" id="miras-form-submit">إرسال الطلب</button>
</form>

<script>
// تعيين رابط الصفحة و dial code عند تغيير الدولة
document.addEventListener('DOMContentLoaded', function () {
  var pageUrlInput = document.getElementById('page_url');
  if (pageUrlInput) {
    pageUrlInput.value = window.location.href;
  }

  var countrySelect = document.getElementById('client_country');
  var dialCodeInput = document.getElementById('country_dial_code');
  if (countrySelect && dialCodeInput) {
    countrySelect.addEventListener('change', function () {
      var selected = countrySelect.options[countrySelect.selectedIndex];
      var dial = selected.getAttribute('data-dial') || '';
      dialCodeInput.value = dial;
    });
  }
});

document.getElementById('miras-lead-form').addEventListener('submit', function (e) {
  e.preventDefault();

  var form = this;
  var submitBtn = document.getElementById('miras-form-submit');
  var messageBox = document.getElementById('miras-form-message');
  var humanCheck = document.getElementById('human_check');

  messageBox.style.display = 'none';
  messageBox.innerHTML = '';

  if (!humanCheck.checked) {
    messageBox.style.display = 'block';
    messageBox.className = 'form-message error';
    messageBox.innerHTML = 'الرجاء تأكيد أنك إنسان وليست روبوت.';
    return;
  }

  var honeypot = document.getElementById('extra_field').value;
  if (honeypot !== '') {
    // بوت
    return;
  }

  // تأكد من وجود كود الدولة
  var countrySelect = document.getElementById('client_country');
  if (!countrySelect.value) {
    messageBox.style.display = 'block';
    messageBox.className = 'form-message error';
    messageBox.innerHTML = 'الرجاء اختيار الدولة.';
    return;
  }

  var formData = new FormData(form);

  submitBtn.disabled = true;
  submitBtn.innerText = 'جاري الإرسال...';

  fetch('https://form.emargates.com/lead-handler.php', {
    method: 'POST',
    body: formData
  })
    .then(function (response) { return response.json(); })
    .then(function (data) {
      messageBox.style.display = 'block';
      if (data.success) {
        messageBox.className = 'form-message success';
        messageBox.innerHTML = data.message || ('شكراً يا ' + (data.name || '') + '، تم استلام طلبك بنجاح.');
        form.reset();
      } else {
        messageBox.className = 'form-message error';
        messageBox.innerHTML = data.message || 'حدث خطأ أثناء الإرسال، الرجاء المحاولة مرة أخرى.';
      }
    })
    .catch(function (error) {
      console.error(error);
      messageBox.style.display = 'block';
      messageBox.className = 'form-message error';
      messageBox.innerHTML = 'حدث خطأ غير متوقع، الرجاء المحاولة لاحقاً.';
    })
    .finally(function () {
      submitBtn.disabled = false;
      submitBtn.innerText = 'إرسال الطلب';
    });
});
</script>
