<?php
// lead-handler.php
header('Content-Type: application/json; charset=utf-8');
require_once __DIR__ . '/config.php';

function json_response($success, $message, $extra = []) {
    $response = array_merge([
        'success' => $success,
        'message' => $message
    ], $extra);
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    json_response(false, 'طريقة الطلب غير مسموحة.');
}

// التقاط القيم
$client_name        = trim($_POST['client_name'] ?? '');
$client_phone_raw   = trim($_POST['client_phone'] ?? '');
$country_code       = trim($_POST['client_country'] ?? '');
$country_dial_code  = trim($_POST['country_dial_code'] ?? '');
$city_district      = trim($_POST['city_district'] ?? '');
$project_type       = trim($_POST['project_type'] ?? '');
$project_details    = trim($_POST['project_details'] ?? '');
$want_estimated_cost= isset($_POST['want_estimated_cost']) && $_POST['want_estimated_cost'] == '1' ? 1 : 0;
$page_url           = trim($_POST['page_url'] ?? '');
$brand              = trim($_POST['brand'] ?? 'miras');
$human_check        = $_POST['human_check'] ?? '';
$extra_field        = trim($_POST['extra_field'] ?? '');

// Honeypot
if ($extra_field !== '') {
    json_response(true, 'تم استلام طلبك، شكراً لك.');
}

// كابتشا
if ($human_check != '1') {
    json_response(false, 'الرجاء تأكيد أنك إنسان وليست روبوت.');
}

// تحقق الحقول الإلزامية
if ($client_name === '' || $client_phone_raw === '' || $country_code === '' || $city_district === '' || $project_type === '' || $project_details === '') {
    json_response(false, 'الرجاء تعبئة جميع الحقول الإلزامية.');
}

// اسم الدولة من الكود
$country_names = [
    'SA' => 'السعودية',
    'AE' => 'الإمارات',
    'EG' => 'مصر',
    'JO' => 'الأردن',
    'KW' => 'الكويت',
    'QA' => 'قطر',
    'BH' => 'البحرين',
    'OM' => 'عمان',
    'LB' => 'لبنان',
    'IQ' => 'العراق',
    'SY' => 'سوريا',
    'YE' => 'اليمن',
    'LY' => 'ليبيا',
    'TN' => 'تونس',
    'DZ' => 'الجزائر',
    'MA' => 'المغرب',
    'SD' => 'السودان',
    'PS' => 'فلسطين',
];
$country_name = $country_names[$country_code] ?? $country_code;

// تنسيق رقم الهاتف
$normalized = preg_replace('/\D+/', '', $client_phone_raw);

if ($country_dial_code === '') {
    $country_dial_code = '966';
}

// إزالة أصفار زائدة
$normalized = ltrim($normalized, '0');

// لو الرقم يحتوي كود الدولة في أوله، نحذف الكود من الجزء المحلي
if (strpos($normalized, $country_dial_code) === 0) {
    $normalized = substr($normalized, strlen($country_dial_code));
}

// إزالة أي صفر في البداية بعد الكود
$normalized = ltrim($normalized, '0');

// الرقم النهائي
$client_phone_normalized = $country_dial_code . $normalized;

// معلومات إضافية
$ip_address = $_SERVER['REMOTE_ADDR'] ?? null;
$user_agent = $_SERVER['HTTP_USER_AGENT'] ?? null;

// حفظ في قاعدة البيانات
try {
    $pdo = get_pdo();
    $stmt = $pdo->prepare("
        INSERT INTO lead_requests
        (client_name, client_phone_raw, client_phone_normalized, country_code, country_name, country_dial_code, city_district, project_type, project_details, want_estimated_cost, page_url, brand, ip_address, user_agent, is_human, whatsapp_status, email_status, make_status)
        VALUES
        (:client_name, :client_phone_raw, :client_phone_normalized, :country_code, :country_name, :country_dial_code, :city_district, :project_type, :project_details, :want_estimated_cost, :page_url, :brand, :ip_address, :user_agent, 1, 'pending', 'pending', 'pending')
    ");
    $stmt->execute([
        ':client_name'             => $client_name,
        ':client_phone_raw'        => $client_phone_raw,
        ':client_phone_normalized' => $client_phone_normalized,
        ':country_code'            => $country_code,
        ':country_name'            => $country_name,
        ':country_dial_code'       => $country_dial_code,
        ':city_district'           => $city_district,
        ':project_type'            => $project_type,
        ':project_details'         => $project_details,
        ':want_estimated_cost'     => $want_estimated_cost,
        ':page_url'                => $page_url,
        ':brand'                   => $brand,
        ':ip_address'              => $ip_address,
        ':user_agent'              => $user_agent,
    ]);
    $lead_id = $pdo->lastInsertId();
} catch (Exception $e) {
    http_response_code(500);
    json_response(false, 'حدث خطأ أثناء حفظ البيانات، الرجاء المحاولة لاحقاً.');
}

// إرسال الإيميل عبر PHPMailer
$email_status = 'pending';
try {
    require_once __DIR__ . '/vendor/autoload.php'; // تأكد من تركيب PHPMailer عبر Composer
    $mail = new PHPMailer\PHPMailer\PHPMailer(true);
    $mail->isSMTP();
    $mail->Host       = SMTP_HOST;
    $mail->SMTPAuth   = true;
    $mail->Username   = SMTP_USER;
    $mail->Password   = SMTP_PASS;
    $mail->SMTPSecure = SMTP_SECURE;
    $mail->Port       = SMTP_PORT;

    $mail->setFrom(MAIL_FROM, MAIL_FROM_NAME);
    $mail->addAddress(MAIL_TO);

    $mail->CharSet = 'UTF-8';
    $mail->Subject = 'طلب جديد من نموذج المشاريع (' . $brand . ')';

    $body  = "وصل طلب جديد:\n\n";
    $body .= "الاسم: {$client_name}\n";
    $body .= "رقم الجوال (خام): {$client_phone_raw}\n";
    $body .= "رقم الجوال (منسق): {$client_phone_normalized}\n";
    $body .= "الدولة: {$country_name}\n";
    $body .= "المدينة/الحي: {$city_district}\n";
    $body .= "نوع المشروع: {$project_type}\n";
    $body .= "تفاصيل المشروع:\n{$project_details}\n\n";
    $body .= "طلب حساب تكلفة افتراضية؟ " . ($want_estimated_cost ? "نعم" : "لا") . "\n\n";
    $body .= "البراند: {$brand}\n";
    $body .= "رابط الصفحة: {$page_url}\n";
    $body .= "IP: {$ip_address}\n";

    $mail->Body = $body;
    $mail->send();

    $email_status = 'sent';
} catch (Exception $e) {
    $email_status = 'error';
}

// إرسال واتساب عبر UltraMsg
$whatsapp_status = 'pending';
try {
    $phone_for_whatsapp = $client_phone_normalized; // قد تحتاج + في البداية حسب إعداد UltraMsg
    $msg = str_replace(
        ['{name}', '{project_type}'],
        [$client_name, $project_type],
        WHATSAPP_TEMPLATE
    );

    $payload = [
        'token' => ULTRA_TOKEN,
        'to'    => $phone_for_whatsapp,
        'body'  => $msg
    ];

    $ch = curl_init(ULTRA_API_URL);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($payload));
    $resp = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $err = curl_error($ch);
    curl_close($ch);

    if ($http_code >= 200 && $http_code < 300 && !$err) {
        $whatsapp_status = 'sent';
    } else {
        $whatsapp_status = 'error';
    }
} catch (Exception $e) {
    $whatsapp_status = 'error';
}

// إرسال إلى Make.com Webhook
$make_status = 'pending';
if (MAKE_WEBHOOK_URL) {
    try {
        $payload = [
            'lead_id'            => $lead_id,
            'client_name'        => $client_name,
            'client_phone'       => $client_phone_normalized,
            'client_phone_raw'   => $client_phone_raw,
            'country_code'       => $country_code,
            'country_name'       => $country_name,
            'city_district'      => $city_district,
            'project_type'       => $project_type,
            'project_details'    => $project_details,
            'want_estimated_cost'=> $want_estimated_cost,
            'page_url'           => $page_url,
            'brand'              => $brand,
            'ip_address'         => $ip_address,
            'user_agent'         => $user_agent,
            'source'             => 'lead_hub_form'
        ];

        $ch = curl_init(MAKE_WEBHOOK_URL);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json; charset=utf-8']);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload, JSON_UNESCAPED_UNICODE));
        $resp = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $err = curl_error($ch);
        curl_close($ch);

        if ($http_code >= 200 && $http_code < 300 && !$err) {
            $make_status = 'sent_to_make';
        } else {
            $make_status = 'make_error';
        }
    } catch (Exception $e) {
        $make_status = 'make_error';
    }
}

// تحديث حالات الإرسال
try {
    $stmt = $pdo->prepare("
        UPDATE lead_requests
        SET whatsapp_status = :whatsapp_status,
            email_status    = :email_status,
            make_status     = :make_status
        WHERE id = :id
    ");
    $stmt->execute([
        ':whatsapp_status' => $whatsapp_status,
        ':email_status'    => $email_status,
        ':make_status'     => $make_status,
        ':id'              => $lead_id
    ]);
} catch (Exception $e) {
    // تجاهل الخطأ
}

json_response(true, 'شكراً يا ' . $client_name . '، تم استلام طلبك بنجاح وسنقوم بالتواصل معك قريباً.', [
    'name' => $client_name
]);
